/** !------------------------------------------------------------------------->
*
*  @file <BusConfiguration>_tx.h
*
*  @creationDate 12 February 2025 14:58:44
*
*  @brief 
*    This is a generated BusCfg_tx header file for manual and cyclis PDU triggering.
*    Any changes will be lost, during the next generation cycle
*
*  @author
*
*  @description
*
*  @copyright
*    Copyright 2025, dSPACE GmbH. All rights reserved.
*   
*!-------------------------------------------------------------------------->*/


#pragma once



EXTERN_C_DECL volatile sint64 Bus_Configuration__1__10897_BusCfg_CurrentTime;

EXTERN_C_DECL BusCfgTxPdu Bus_Configuration__1__10897_BusCfgTxPdus[];

#define Com_TX_Compressor_10843_10561_10897 0
#define Com_TX_Commands_10842_10560_10897 1
#define Com_TX_HeatTransfer_10841_10560_10897 2
#define Com_TX_Traction_10840_10560_10897 3
#define Com_TX_TempBatt_10839_10561_10897 4
#define Com_TX_Temperatures_10838_10561_10897 5
#define Com_TX_Conditions_10837_10561_10897 6

/**************************************************************************************************\
 *** FUNCTION:
 ***     Bus_Configuration__1__10897_BusCfgTx_OnStart
 *** 
 *** DESCRIPTION:
 ***     This function is called in OnStart application phase.
 ***
 *** PARAMETERS:
 ***     -/-
 *** 
 *** RETURNS:
 ***     void
\**************************************************************************************************/
EXTERN_C_DECL void Bus_Configuration__1__10897_BusCfgTx_OnStart(void);

/**************************************************************************************************\
 *** FUNCTION:
 ***     Bus_Configuration__1__10897_BusCfgTx_OnStop
 *** 
 *** DESCRIPTION:
 ***     This function is called in OnStop application phase.
 ***
 *** PARAMETERS:
 ***     -/-
 *** 
 *** RETURNS:
 ***     void
\**************************************************************************************************/
EXTERN_C_DECL void Bus_Configuration__1__10897_BusCfgTx_OnStop(void);

/**************************************************************************************************\
 *** FUNCTION:
 ***     Bus_Configuration__1__10897_BusCfgTx_VariableInitialize()
 *** 
 *** DESCRIPTION:
 ***    This function is called before the application starts and may be used to extend the
 ***    initialization phase.
 ***
 *** PARAMETERS:
 *** 
 *** RETURNS:
 ***     void
\**************************************************************************************************/
EXTERN_C_DECL void Bus_Configuration__1__10897_BusCfgTx_VariableInitialize(void);

/**************************************************************************************************\
 *** FUNCTION:
 ***     Bus_Configuration__1__10897_BusCfgTx_SetPduPeriodOffset()
 *** 
 *** DESCRIPTION:
 ***    This function is called if the value of period or offset of a CyclicTimingControl 
 ***    feature change.
 ***
 *** PARAMETERS:
 ***    PduIdType pduId        Identifier of the PDU
 ***    sint32    period       New periof value of the PDU
 ***    sint32    offset       New offet of the PDU
 *** 
 *** RETURNS:
 ***     void
\**************************************************************************************************/
EXTERN_C_DECL void Bus_Configuration__1__10897_BusCfgTx_SetPduPeriodOffset(PduIdType pduId, sint32 period, sint32 offset);

/**************************************************************************************************\
 *** FUNCTION:
 ***    Bus_Configuration__1__10897_BusCfgTx_SetPduPending
 *** 
 *** DESCRIPTION:
 ***    This function adds a new entry to trigger cache sorted by message priority
 ***
 *** PARAMETERS:
 ***    PduIdType pduId        Identifier of the PDU
 *** 
 *** RETURNS:
 ***     E_OK on success, E_NOT_OK if cache is full
\**************************************************************************************************/
EXTERN_C_DECL Std_ReturnType Bus_Configuration__1__10897_BusCfgTx_SetPduPending(PduIdType pduId);

/**************************************************************************************************\
 *** FUNCTION:
 ***     Bus_Configuration__1__10897_BusCfgTx_TriggerPendingPdus()
 *** 
 *** DESCRIPTION:
 ***    This function is called to set pending flag of specified PDU.
 ***
 *** PARAMETERS:
 *** 
 *** RETURNS:
 ***     void
\**************************************************************************************************/
EXTERN_C_DECL void Bus_Configuration__1__10897_BusCfgTx_TriggerPendingPdus(void);

